import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 5))

# Define the grid size
rows, cols = 2, 5

# Define the colors for clear, occupied, and painted tiles
clear_color = 'lightgreen'
occupied_color = 'salmon'
painted_color = 'white'

# Define the robot color
robot1_color = 'black'

# Define the tile status
tile_status = {
    'tile_0-1': 'clear', 'tile_0-2': 'clear', 'tile_0-3': 'clear', 'tile_0-4': 'occupied', 'tile_0-5': 'clear',
    'tile_1-1': 'clear', 'tile_1-2': 'clear', 'tile_1-3': 'painted', 'tile_1-4': 'clear', 'tile_1-5': 'painted',
}

# Define robot position
robot_position = (0, 3)

# Draw the tiles
for row in range(rows):
    for col in range(cols):
        tile_id = f'tile_{row}-{col+1}'
        status = tile_status[tile_id]
        if status == 'clear':
            color = clear_color
        elif status == 'occupied':
            color = occupied_color
        elif status == 'painted':
            color = painted_color
        rect = patches.Rectangle((col, rows-row-1), 1, 1, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows-row-0.5, tile_id, ha='center', va='center', fontsize=8, color='black')

# Draw the robot
row, col = robot_position
circle = patches.Circle((col + 0.5, rows-row-0.5), 0.3, edgecolor='black', facecolor=robot1_color)
ax.add_patch(circle)
ax.text(col + 0.5, rows-row-0.7, 'robot1', ha='center', va='center', fontsize=8, color='white')

# Draw available colors
available_colors = ['white', 'black']
for i, color in enumerate(available_colors):
    rect = patches.Rectangle((cols + 0.5, rows-i-0.5), 0.5, 0.5, linewidth=1, edgecolor='black', facecolor=color)
    ax.add_patch(rect)
    ax.text(cols + 0.75, rows-i-0.25, f'color_{color}', ha='center', va='center', fontsize=8, color='black' if color == 'white' else 'white')

# Set limits and labels
ax.set_xlim(0, cols + 1.5)
ax.set_ylim(0, rows)
ax.set_xticks([])
ax.set_yticks([])

# Add legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=occupied_color, edgecolor='black', label='Occupied Tile'),
    patches.Patch(facecolor=painted_color, edgecolor='black', label='Painted Tile (White)'),
    patches.Patch(facecolor=robot1_color, edgecolor='black', label='Robot1 (Black)'),
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save the figure
plt.savefig('<PATH_REMOVED>', bbox_inches='tight')
plt.show()